function [val1 val2 a1 a2] = find_b(b, x, y)
%
% evaluates a function given the values of b
% for the model: Y = a log(X - b)
%
% when val1 = 0 = val2 then input b = optimal b
%
% val1 constructed using the derivative of a substituted into the derivative for b
% val2 constructed using the derivative of b substituted into the derivative for a
%
% the solvers that call this function tend to only consider val1
%
% Simon Anastasiadis 01/07/2011
% Final version used 12/07/2011 for project

%% First val

a1 = sum(y ./ (x - b)) / sum( log(x - b) ./ (x - b) );

val1 = a1 * sum( (log(x - b)).^2 ) - sum( y .* log(x - b) );

%% Second val

a2 = sum( y .* log(x - b) ) ./ sum( (log(x - b)).^2 );

val2 = sum( y ./ (x - b) ) - a2 * sum( log(x - b) ./ (x - b) );

end
